#pragma rtGlobals=1		// Use modern global access method.

//FUNCTIONS

//these are more a template to create whatever is needed
//Function DoAllStuff()
//Function ModifyTrajectoryPlot(sGraphName)

// use to import data
//Function/S ImportTrajectoryFile(sPath)	: use to import data
//Function/S RemoveShortTrajectories(sList, sDelimiter, vDataPoints)
//Function PlotTrajectories(sGraphName, sWNtime,sList,sDelimiter)

//EXAMPLES
//ImportTrajectoryFile(DoOpenFileDialog())
//PlotTrajectories("All_traces", "aTime",WaveList("PID*", ";", ""),";")
//PlotTrajectories("All_traces", "aTime", RemoveShortTrajectories(WaveList("PID*", ";", ""), ";", 3),";")
//AddMltplWavesToTrajectoryGraph("Graph2", "Time_pt_10kDa_33.0",WaveList("PID*33.0", ";", ""),";")


//*****************************************************************************
//Function/S ParseLineOfTrajectoryFile(sLine, sDelimiter, sWaveName)
//Function CreateTrajectoryGraph(sGraphName, sWN, sWNtime)
//Function AddWaveToTrajectoryGraph(sGraphName, sWN, sWNtime)
//Function AddMltplWavesToTrajectoryGraph(sGraphName, sWNtime,sList, sDelimiter)
//Function/S RemoveMltplRepChar(sString, sChar)



Function/S ImportTrajectoryFile(sPath)//, vLabel)
// Input: CSV, DAT files
// file structure:
// label_row1	entry1	entry2	...	entryN_row1
// label_row2	entry1	entry2	...	entryN_row2
// ...
// label_rowM	entry1	entry2	...	entryN_rowM

// N_row1, N_row2, ... N_rowM (number of elements in each row) can be different	
// first wave contans time information and should contain as much entries as longest row!!!

// output:
//	list containing names of all waves created

String sPath // location of file
//Variable vLabel // '1' file contains label at the beginnin of each row; '0' - does not;

String sDelimiter, sWaveName

sDelimiter=" "
sWaveName="temp"

Variable vTrajectoryFile, vLine
String sCurrentLine, sWaveList, sCurrentWaveName

sWaveList=""

//open file
Open /R vTrajectoryFile as sPath
Print "Importing from file '"+sPath+"'"
//Process each line
vLine=0

Do
	FReadLine vTrajectoryFile, sCurrentLine

	if (strlen(sCurrentLine)==0)
		break
	endif

	sprintf  sCurrentWaveName, "%s_%.3d", sWaveName, vLine
	sWaveList=sWaveList+ParseLineOfTrajectoryFile(sCurrentLine, sDelimiter, sCurrentWaveName)+";"
	
	vLine+=1
	
While (1)

Close vTrajectoryFile
return sWaveList

End

Function/S ParseLineOfTrajectoryFile(sLine, sDelimiter, sWaveName)
// parses line of a trajectory file
// output: name of wave where data is stored
// 	if first element is label, it is used as wave name, otherwise sWaveName is used


String sLine, sDelimiter, sWaveName
String sEntry
Variable vPosInList=0
Variable vPosInWave=0

sLine=RemoveMltplRepChar(sLine, sDelimiter) //replace multiple delimiters in row with a single delimiter 

sEntry=StringfromList(vPosInList, sLine, sDelimiter)

if (IsNumber(sEntry))
	//do nothing
	Make/O/N=1 $sWaveName
	Wave wTarget=$sWaveName
	wTarget[0]=str2num(sEntry)
	vPosInWave+=1
else
	sWaveName=sEntry
	Make/O/N=0 $sWaveName 
	Wave wTarget=$sWaveName
endif

vPosInList=1

do
	sEntry=StringfromList(vPosInList, sLine, sDelimiter)
	if (!(isNumber(sEntry)))
		break
	endif
	InsertPoints vPosInWave, 1, wTarget
	wTarget[vPosInWave]=str2num(sEntry)
	vPosInList+=1
	vPosInWave+=1
While (1)

return sWaveName

End

Function CreateTrajectoryGraph(sGraphName, sWN, sWNtime)
String sWN, sGraphName, sWNtime

Display $sWN vs $sWNtime
DoWindow/C $sGraphName 
End

Function AddWaveToTrajectoryGraph(sGraphName, sWN, sWNtime)
String sWN, sGraphName, sWNtime
//String sDerivList, sDerivTemp
DoWindow/F $sGraphName
AppendToGraph $sWN vs $sWNtime

//Differentiate/METH=1 $sWN/X=$sWNtime/D=$sDerivList //compute derivative, start sDerivList

End



Function AddMltplWavesToTrajectoryGraph(sGraphName, sWNtime,sList, sDelimiter)
string sList, sGraphName, sDelimiter, sWNtime
//String sDerivTemp

string stemp
Variable ii=0
Do
	stemp=stringfromlist(ii,sList, sDelimiter)
	if (strlen(stemp)==0)
		break
	endif
	
	AddWaveToTrajectoryGraph(sGraphName, stemp, sWNtime)
	ii+=1
	
While (1)

//take the derivative of each wave and add it to a list for making a histogram later
//Differentiate/METH=1 sWN/X=sWNtime/D=$sDerivTemp //compute derivative, put it in a temporary wave
//Concatenate sDerivTemp, sDerivList //add derivatives to DerivList
//Edit sDerivList
//sprintf  sCurrentWaveName, "%s_%.3d", sWaveName, vLine
//printf  "%s", sDerivList


End

Function PlotTrajectories(sGraphName, sWNtime,sList,sDelimiter)
string sList, sGraphName, sDelimiter, sWNtime
Variable vWavesToPlot

vWavesToPlot=ItemsinList(sList, sDelimiter)

if (vWavesToPlot==0)
	print "No waves in list"
	return 0
endif

CreateTrajectoryGraph(sGraphName, stringfromlist(0, sList, sDelimiter), sWNtime)
sList=RemoveFromList(StringFromList(0, sList, sDelimiter), sList, sDelimiter)
AddMltplWavesToTrajectoryGraph(sGraphName, sWNtime, sList, sDelimiter)
	
end


Function/S RemoveShortTrajectories(sList, sDelimiter, vDataPoints)
String sList, sDelimiter
Variable vDataPoints

string swave
Variable ii=0

do
	swave=stringfromlist(ii, sList, sDelimiter)
	if (strlen(swave)==0)
		break
	endif
	
	wave ww=$swave
	if (DimSize(ww, 0)<vDataPoints)
		sList=RemoveFromList(StringFromList(ii, sList, sDelimiter), sList, sDelimiter)
		ii-=1
	endif
	ii+=1
	
while (1)

return sList

end

Function/S RemoveMltplRepChar(sString, sChar)
String sString, sChar
Variable ii=0

For (ii=0; ii<strlen(sString)-1; ii+=1)
	if (cmpstr(sString[ii],sChar)==0)
		if(cmpstr(sString[ii], sString[ii+1])==0)
			sString=sString[0, ii]+sString[ii+2, strlen(sString)-1]
			ii-=1
		endif
	endif
Endfor
return sString
End



Function DoAllStuff()
// example of importing and plotting data
String sPath=DoOpenFileDialog() 		//select file
String sList=ImportTrajectoryFile(sPath)	// and import all waves

String sTime=StringFromList(0, sList, ";") // wave with time data

sList=RemoveFromList(sTime, sList, ";")

PlotTrajectories("Graph7", sTime,sList,";")

Display sDerivList

ModifyTrajectoryPlot("Graph13")

End

Function ModifyTrajectoryPlot(sGraphName)
// use this as template to create modifications for graph(s)
String sGraphName
DoWindow/F $sGraphName
TextBox/C/N=text0/F=0/S=3/A=MC "Single molecule radius of gyration evolution"
Label bottom "Time (seconds)"
Label left "Rg (microns)"
End

